function insertParam(url, parameterName, parameterValue, atStart){
    replaceDuplicates = true;

    if(url.indexOf('#') > 0){
        var cl = url.indexOf('#');
        urlhash = url.substring(url.indexOf('#'),url.length);
    } else {
        urlhash = '';
        cl = url.length;
    }
    sourceUrl = url.substring(0,cl);

    var urlParts = sourceUrl.split("?");
    var newQueryString = "";

    if (urlParts.length > 1)
    {
        var parameters = urlParts[1].split("&");
        for (var i=0; (i < parameters.length); i++)
        {
            var parameterParts = parameters[i].split("=");
            if (!(replaceDuplicates && parameterParts[0] == parameterName))
            {
                if (newQueryString == "") {
                    newQueryString = "?" + parameterParts[0] + "=" + (parameterParts[1]?parameterParts[1]:'');
                }
                else {
                    newQueryString += "&";
                newQueryString += parameterParts[0] + "=" + (parameterParts[1]?parameterParts[1]:'');
            	}
            }
        }
    }
    if (newQueryString == "")
        newQueryString = "?";

    if(atStart){
        newQueryString = '?'+ parameterName + "=" + parameterValue + (newQueryString.length>1?'&'+newQueryString.substring(1):'');
    } else {
        if (newQueryString !== "" && newQueryString != '?')
            newQueryString += "&";
        newQueryString += parameterName + "=" + (parameterValue?parameterValue:'');
    }
    return urlParts[0] + newQueryString + urlhash;
};

function ytVidId(url) {
  var p = /^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/;
  return (url.match(p)) ? RegExp.$1 : false;
  //return (url.match(p)) ? true : false;
}

jQuery(document).ready(function() {
	jQuery('.portfolio-wrapper').hide();
	jQuery('.portfolio-tabs ').hide();
	jQuery('.faq-tabs ').hide();
	if(jQuery('.portfolio').length >= 1) {
		jQuery('#content').append('<div class="loading-container"><img src="data:image/gif;base64,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" alt="Loading..."><div class="loading-msg">'+js_local_vars.portfolio_loading_text+'</div>');
	}
	if(jQuery('.faqs').length >= 1) {
		jQuery('#content').append('<div class="loading-container"><img src="data:image/gif;base64,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" alt="Loading..."><div class="loading-msg">'+js_local_vars.faqs_loading_text+'</div>');
	}

	var iframes = jQuery('iframe');
	jQuery.each(iframes, function(i, v) {
		var src = jQuery(this).attr('src');
		if(src) {
			<?php if(!$data['status_vimeo']): ?>
			if(src.indexOf('vimeo') >= 1) {
				jQuery(this).attr('id', 'player_'+(i+1));
				var new_src = insertParam(src, 'api', '1', false);
				var new_src_2 = insertParam(new_src, 'player_id', 'player_'+(i+1), false);

				jQuery(this).attr('src', new_src_2);
			}
			<?php endif; ?>
			<?php if(!$data['status_yt']): ?>
			if(ytVidId(src)) {
				jQuery(this).parent().wrap('<span class="play3" />');
				window.yt_vid_exists = true;
			}
			<?php endif; ?>
		}
	});
});
jQuery(window).load(function() {
	if(jQuery('#sidebar').is(':visible')) {
		jQuery('.post-content div.portfolio').each(function() {
			var columns = jQuery(this).data('columns');
			jQuery(this).addClass('portfolio-'+columns+'-sidebar');
		});
	}

	if(jQuery().isotope) {
		  // modified Isotope methods for gutters in masonry
		  jQuery.Isotope.prototype._getMasonryGutterColumns = function() {
		    var gutter = this.options.masonry && this.options.masonry.gutterWidth || 0;
		        containerWidth = this.element.width();

		    this.masonry.columnWidth = this.options.masonry && this.options.masonry.columnWidth ||
		                  // or use the size of the first item
		                  this.$filteredAtoms.outerWidth(true) ||
		                  // if there's no items, use size of container
		                  containerWidth;

		    this.masonry.columnWidth += gutter;

		    this.masonry.cols = Math.floor( ( containerWidth + gutter ) / this.masonry.columnWidth );
		    this.masonry.cols = Math.max( this.masonry.cols, 1 );
		  };

		  jQuery.Isotope.prototype._masonryReset = function() {
		    // layout-specific props
		    this.masonry = {};
		    // FIXME shouldn't have to call this again
		    this._getMasonryGutterColumns();
		    var i = this.masonry.cols;
		    this.masonry.colYs = [];
		    while (i--) {
		      this.masonry.colYs.push( 0 );
		    }
		  };

		  jQuery.Isotope.prototype._masonryResizeChanged = function() {
		    var prevSegments = this.masonry.cols;
		    // update cols/rows
		    this._getMasonryGutterColumns();
		    // return if updated cols/rows is not equal to previous
		    return ( this.masonry.cols !== prevSegments );
		  };

		imagesLoaded(jQuery('.portfolio-one .portfolio-wrapper'), function() {
			jQuery('.portfolio-wrapper').fadeIn();
			jQuery('.portfolio-tabs').fadeIn();
			jQuery('.faq-tabs').fadeIn();
			jQuery('.loading-container').fadeOut();
			jQuery('.portfolio-one .portfolio-wrapper').isotope({
				// options
				itemSelector: '.portfolio-item',
				layoutMode: 'straightDown',
				transformsEnabled: false
			});
		});

		imagesLoaded(jQuery('.portfolio-two .portfolio-wrapper, .portfolio-three .portfolio-wrapper, .portfolio-four .portfolio-wrapper'),function() {
			jQuery('.portfolio-wrapper').fadeIn();
			jQuery('.portfolio-tabs').fadeIn();
			jQuery('.loading-container').fadeOut();
			jQuery('.portfolio-two .portfolio-wrapper, .portfolio-three .portfolio-wrapper, .portfolio-four .portfolio-wrapper').isotope({
				// options
				itemSelector: '.portfolio-item',
				layoutMode: 'fitRows',
				transformsEnabled: false
			});
		});

		var masonryContainer = jQuery('.portfolio-masonry .portfolio-wrapper');
		imagesLoaded(masonryContainer, function() {
			jQuery('.portfolio-wrapper').fadeIn();
			jQuery('.portfolio-tabs').fadeIn();
			jQuery('.loading-container').fadeOut();
			var gridTwo = masonryContainer.parent().hasClass('portfolio-grid-2');
			var columns;
			if(gridTwo) {
				columns = 2;
			} else {
				columns = 3;
			}
			masonryContainer.isotope({
				// options
				itemSelector: '.portfolio-item',
				layoutMode: 'masonry',
				transformsEnabled: false,
				masonry: { columnWidth: masonryContainer.width() / columns }
			});
		});
	}

	if(jQuery().flexslider) {
		var avada_ytplayer;

		<?php if(!$data['status_yt']): ?>
		if(window.yt_vid_exists == true) {
			var tag = document.createElement('script');
			tag.src = "https://www.youtube.com/iframe_api";
			var firstScriptTag = document.getElementsByTagName('script')[0];
			firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

			function getFrameID(id){
			    var elem = document.getElementById(id);
			    if (elem) {
			        if(/^iframe$/i.test(elem.tagName)) return id; //Frame, OK
			        // else: Look for frame
			        var elems = elem.getElementsByTagName("iframe");
			        if (!elems.length) return null; //No iframe found, FAILURE
			        for (var i=0; i<elems.length; i++) {
			           if (/^https?:\/\/(?:www\.)?youtube(?:-nocookie)?\.com(\/|$)/i.test(elems[i].src)) break;
			        }
			        elem = elems[i]; //The only, or the best iFrame
			        if (elem.id) return elem.id; //Existing ID, return it
			        // else: Create a new ID
			        do { //Keep postfixing `-frame` until the ID is unique
			            id += "-frame";
			        } while (document.getElementById(id));
			        elem.id = id;
			        return id;
			    }
			    // If no element, return null.
			    return null;
			}

			// Define YT_ready function.
			var YT_ready = (function() {
			    var onReady_funcs = [], api_isReady = false;
			    /* @param func function     Function to execute on ready
			     * @param func Boolean      If true, all qeued functions are executed
			     * @param b_before Boolean  If true, the func will added to the first
			                                 position in the queue*/
			    return function(func, b_before) {
			        if (func === true) {
			            api_isReady = true;
			            while (onReady_funcs.length) {
			                // Removes the first func from the array, and execute func
			                onReady_funcs.shift()();
			            }
			        } else if (typeof func == "function") {
			            if (api_isReady) func();
			            else onReady_funcs[b_before?"unshift":"push"](func);
			        }
			    }
			})();
			// This function will be called when the API is fully loaded
			function onYouTubePlayerAPIReady() {YT_ready(true)}
		}
		<?php endif; ?>

		<?php if(!$data['status_vimeo']): ?>
		function ready(player_id) {
		    var froogaloop = $f(player_id);

		    froogaloop.addEvent('play', function(data) {
		    	jQuery('#'+player_id).parents('li').parent().parent().flexslider("pause");
		    });

		    froogaloop.addEvent('pause', function(data) {
		        jQuery('#'+player_id).parents('li').parent().parent().flexslider("play");
		    });
		}

		var vimeoPlayers = jQuery('.flexslider').find('iframe'), player;

		jQuery('.flexslider').find('iframe').each(function() {
			var id = jQuery(this).attr('id');

			if(id) {
				$f(id).addEvent('ready', ready);
			}
		});

		function addEvent(element, eventName, callback) {
		    if (element.addEventListener) {
		        element.addEventListener(eventName, callback, false)
		    } else {
		        element.attachEvent(eventName, callback, false);
		    }
		}
		<?php endif; ?>

		jQuery('.full-video, .video-shortcode, .wooslider .slide-content, .post-content').fitVids();

		if(jQuery('.tfs-slider').length >= 1) {
			//jQuery('.tfs-slider').flexslider('destroy');

			jQuery('.tfs-slider').flexslider({
				animation: "<?php if($data['tfs_animation']) { echo $data['tfs_animation']; } else { echo 'fade'; } ?>",
				slideshow: <?php if($data['tfs_autoplay']) { echo 'true'; } else { echo 'false'; } ?>,
				slideshowSpeed: <?php if($data['tfs_slideshow_speed']) { echo $data['tfs_slideshow_speed']; } else { echo '7000'; } ?>,
				animationSpeed: <?php if($data['tfs_animation_speed']) { echo $data['tfs_animation_speed']; } else { echo '600'; } ?>,
				smoothHeight: true,
				pauseOnHover: false,
				useCSS: false,
				video: true,
				start: function(slider) {
			        if(typeof(slider.slides) !== 'undefined' && slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
			           <?php if($data['pagination_video_slide']): ?>
			           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
			           <?php else: ?>
			           jQuery(slider).find('.flex-control-nav').hide();
			           <?php endif; ?>
			           <?php if(!$data['status_yt']): ?>
			           if(window.yt_vid_exists == true) {
						YT_ready(function() {
							new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
								events: {
									'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
								}
							});
						});
						}
						<?php endif; ?>
			       } else {
			           <?php if($data['pagination_video_slide']): ?>
			           jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
			           <?php else: ?>
			           jQuery(slider).find('.flex-control-nav').show();
			           <?php endif; ?>
			       }
				},
			    before: function(slider) {
			        if(slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
			        	<?php if(!$data['status_vimeo']): ?>
			           	$f( slider.slides.eq(slider.currentSlide).find('iframe')[0] ).api('pause');
			           <?php endif; ?>

			           <?php if(!$data['status_yt']): ?>
			           if(window.yt_vid_exists == true) {
						YT_ready(function() {
							new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
								events: {
									'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
								}
							});
						});
						}
						<?php endif; ?>

			           /* ------------------  YOUTUBE FOR AUTOSLIDER ------------------ */
			           playVideoAndPauseOthers(slider);
			       }
			    },
			   	after: function(slider) {
			        if(slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
			           <?php if($data['pagination_video_slide']): ?>
			           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
			           <?php else: ?>
			           jQuery(slider).find('.flex-control-nav').hide();
			           <?php endif; ?>

			           <?php if(!$data['status_yt']): ?>
			           if(window.yt_vid_exists == true) {
						YT_ready(function() {
							new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
								events: {
									'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
								}
							});
						});
						}
						<?php endif; ?>
			       } else {
			           <?php if($data['pagination_video_slide']): ?>
			           jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
			           <?php else: ?>
			           jQuery(slider).find('.flex-control-nav').show();
			           <?php endif; ?>
			       }
			    }
			});
		}

		if(js_local_vars.page_smoothHeight === 'false') {
			page_smoothHeight = false;
		} else {
			page_smoothHeight = true;
		}

        jQuery('.grid-layout .flexslider').flexslider({
            slideshow: <?php if($data["slideshow_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
            slideshowSpeed: <?php if($data['slideshow_speed']) { echo $data['slideshow_speed']; } else { echo '7000'; } ?>,
            video: true,
            smoothHeight: page_smoothHeight,
            pauseOnHover: false,
            useCSS: false,
            start: function(slider) {
                if (typeof(slider.slides) !== 'undefined' && slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
                    <?php if($data['pagination_video_slide']): ?>
                    jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
                    <?php else: ?>
                    jQuery(slider).find('.flex-control-nav').hide();
                    <?php endif; ?>

                    <?php if(!$data['status_yt']): ?>
                    if(window.yt_vid_exists == true) {
                    YT_ready(function() {
                        new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
                            events: {
                                'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
                            }
                        });
                    });
                	}
                    <?php endif; ?>
                } else {
                    <?php if($data['pagination_video_slide']): ?>
                    jQuery(slider).find('.flex-control-nav').css('bottom', '0');
                    <?php else: ?>
                    jQuery(slider).find('.flex-control-nav').show();
                    <?php endif; ?>
                }
            },
            before: function(slider) {
                if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
                    <?php if(!$data['status_vimeo']): ?>$f(slider.slides.eq(slider.currentSlide).find('iframe')[0] ).api('pause');<?php endif; ?>
                    <?php if(!$data['status_yt']): ?>
                    if(window.yt_vid_exists == true) {
                    YT_ready(function() {
                        new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
                            events: {
                                'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
                            }
                        });
                    });
                	}
                    <?php endif; ?>

                    /* ------------------  YOUTUBE FOR AUTOSLIDER ------------------ */
                    playVideoAndPauseOthers(slider);
                }
            },
            after: function(slider) {
                if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
                    <?php if($data['pagination_video_slide']): ?>
                    jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
                    <?php else: ?>
                    jQuery(slider).find('.flex-control-nav').hide();
                    <?php endif; ?>
                    <?php if(!$data['status_yt']): ?>
                    if(window.yt_vid_exists == true) {
                    YT_ready(function() {
                        new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
                            events: {
                                'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
                            }
                        });
                    });
                	}
                    <?php endif; ?>
                } else {
                    <?php if($data['pagination_video_slide']): ?>
                    jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
                    <?php else: ?>
                    jQuery(slider).find('.flex-control-nav').show();
                    <?php endif; ?>
                }
            }
        });

		if(js_local_vars.flex_smoothHeight === 'false') {
			flex_smoothHeight = false;
		} else {
			flex_smoothHeight = true;
		}

		jQuery('.flexslider').flexslider({
			slideshow: <?php if($data["slideshow_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
			slideshowSpeed: <?php if($data['slideshow_speed']) { echo $data['slideshow_speed']; } else { echo '7000'; } ?>,
			video: true,
			smoothHeight: flex_smoothHeight,
			pauseOnHover: false,
			useCSS: false,
			start: function(slider) {
		        if (typeof(slider.slides) !== 'undefined' && slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
			},
		    before: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if(!$data['status_vimeo']): ?>$f(slider.slides.eq(slider.currentSlide).find('iframe')[0] ).api('pause');<?php endif; ?>
		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>

		           /* ------------------  YOUTUBE FOR AUTOSLIDER ------------------ */
		           playVideoAndPauseOthers(slider);
		       }
		    },
		   	after: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>
		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
		    }
		});

		function playVideoAndPauseOthers(slider) {
			jQuery(slider).find('iframe').each(function(i) {
				var func = 'stopVideo';
				this.contentWindow.postMessage('{"event":"command","func":"' + func + '","args":""}', '*');
			});
		}

		/* ------------------ PREV & NEXT BUTTON FOR FLEXSLIDER (YOUTUBE) ------------------ */
		jQuery('.flex-next, .flex-prev').click(function() {
			playVideoAndPauseOthers(jQuery(this).parents('.flexslider, .tfs-slider'));
		});

		function onPlayerStateChange(frame, slider) {
			return function(event) {
		        if(event.data == YT.PlayerState.PLAYING) {
		            jQuery(slider).flexslider("pause");
		        }
		        if(event.data == YT.PlayerState.PAUSED) {
		        	jQuery(slider).flexslider("play");
		        }
	    	}
		}
	}

	if(jQuery().isotope) {
		var gridwidth = (jQuery('.grid-layout').width() / 2) - 22;
		jQuery('.grid-layout .post').css('width', gridwidth);
		jQuery('.grid-layout').isotope({
			layoutMode: 'masonry',
			itemSelector: '.post',
			transformsEnabled: false,
			masonry: {
				columnWidth: gridwidth,
				gutterWidth: 40
			},
		});

		var gridwidth = (jQuery('.grid-full-layout-3').width() / 3) - 30;
		jQuery('.grid-full-layout-3 .post').css('width', gridwidth);
		jQuery('.grid-full-layout-3').isotope({
			layoutMode: 'masonry',
			itemSelector: '.post',
			transformsEnabled: false,
			masonry: {
				columnWidth: gridwidth,
				gutterWidth: 40
			},
		});

		var gridwidth = (jQuery('.grid-full-layout-4').width() / 4) - 35;
		jQuery('.grid-full-layout-4 .post').css('width', gridwidth);
		jQuery('.grid-full-layout-4').isotope({
			layoutMode: 'masonry',
			itemSelector: '.post',
			transformsEnabled: false,
			masonry: {
				columnWidth: gridwidth,
				gutterWidth: 40
			},
		});
	}

	<?php if(!$data['avada_rev_styles']): ?>
	jQuery('.rev_slider_wrapper').each(function() {
		if(jQuery(this).length >=1 && jQuery(this).find('.tp-bannershadow').length == 0) {
			jQuery('<div class="shadow-left">').appendTo(this);
			jQuery('<div class="shadow-right">').appendTo(this);

			jQuery(this).addClass('avada-skin-rev');
		}
	});

	jQuery('.tparrows').each(function() {
		if(jQuery(this).css('visibility') == 'hidden') {
			jQuery(this).remove();
		}
	});
	<?php endif; ?>
});
jQuery(document).ready(function() {
	function onAfter(curr, next, opts, fwd) {
	  var $ht = jQuery(this).height();

	  //set the container's height to that of the current slide
	  jQuery(this).parent().css('height', $ht);
	}
	if(jQuery().cycle) {
	    jQuery('.reviews').cycle({
			fx: 'fade',
			after: onAfter,
			<?php if($data['testimonials_speed']): ?>
			timeout: <?php echo $data['testimonials_speed']; ?>
			<?php endif; ?>
		});
	}


});
jQuery(window).load(function($) {
	jQuery('.header-social .menu > li').height(jQuery('.header-social').height());
	jQuery('.header-social .menu > li').css('line-height', jQuery('.header-social').height()+'px');
	jQuery('.header-social .menu > li.cart').css('line-height', jQuery('.header-social').height()+'px');

	if(jQuery('.top-menu .cart').width() > 150) {
		new_width = jQuery('.top-menu .cart').width();
		jQuery('.top-menu .cart-contents').css("width", new_width+'px');
		new_width -= 26;
		jQuery('.top-menu .cart-content a').css("width", new_width+'px');
		new_width -= 56;
		jQuery('.top-menu .cart-content a .cart-desc').css("width", new_width+'px');
	};

	if(jQuery().prettyPhoto) {
		var ppArgs = {
			<?php if($data["lightbox_animation_speed"]): ?>
			animation_speed: '<?php echo strtolower($data["lightbox_animation_speed"]); ?>',
			<?php endif; ?>
			overlay_gallery: <?php if($data["lightbox_gallery"]) { echo 'true'; } else { echo 'false'; } ?>,
			autoplay_slideshow: <?php if($data["lightbox_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
			<?php if($data["lightbox_slideshow_speed"]): ?>
			slideshow: <?php echo $data['lightbox_slideshow_speed']; ?>,
			<?php endif; ?>
			<?php if($data["lightbox_opacity"]): ?>
			opacity: <?php echo $data['lightbox_opacity']; ?>,
			<?php endif; ?>
			show_title: <?php if($data["lightbox_title"]) { echo 'true'; } else { echo 'false'; } ?>,
			show_desc: <?php if($data["lightbox_desc"]) { echo 'true'; } else { echo 'false'; } ?>,
			<?php if(!$data["lightbox_social"]) { echo 'social_tools: "",'; } ?>
		};

		jQuery("a[rel^='prettyPhoto']").prettyPhoto(ppArgs);

		<?php if($data['lightbox_post_images']): ?>
		jQuery('.single-post .post-content a').has('img').prettyPhoto(ppArgs);
		<?php endif; ?>

		jQuery('.lightbox-enabled a').has('img').prettyPhoto(ppArgs);

		var mediaQuery = 'desk';

		if (Modernizr.mq('only screen and (max-width: 600px)') || Modernizr.mq('only screen and (max-height: 520px)')) {

			mediaQuery = 'mobile';
			jQuery("a[rel^='prettyPhoto']").unbind('click');
			<?php if($data['lightbox_post_images']): ?>
			jQuery('.single-post .post-content a').has('img').unbind('click');
			<?php endif; ?>
			jQuery('.lightbox-enabled a').has('img').unbind('click');
		}

		// Disables prettyPhoto if screen small
		jQuery(window).on('resize', function() {
			if ((Modernizr.mq('only screen and (max-width: 600px)') || Modernizr.mq('only screen and (max-height: 520px)')) && mediaQuery == 'desk') {
				jQuery("a[rel^='prettyPhoto']").unbind('click.prettyphoto');
				<?php if($data['lightbox_post_images']): ?>
				jQuery('.single-post .post-content a').has('img').unbind('click.prettyphoto');
				<?php endif; ?>
				jQuery('.lightbox-enabled a').has('img').unbind('click.prettyphoto');
				mediaQuery = 'mobile';
			} else if (!Modernizr.mq('only screen and (max-width: 600px)') && !Modernizr.mq('only screen and (max-height: 520px)') && mediaQuery == 'mobile') {
				jQuery("a[rel^='prettyPhoto']").prettyPhoto(ppArgs);
				<?php if($data['lightbox_post_images']): ?>
				jQuery('.single-post .post-content a').has('img').prettyPhoto(ppArgs);
				<?php endif; ?>
				jQuery('.lightbox-enabled a').has('img').prettyPhoto(ppArgs);
				mediaQuery = 'desk';
			}
		});
	}
	<?php if($data['sidenav_behavior'] == 'Click'): ?>
	jQuery('.side-nav li a').live('click', function(e) {
		if(jQuery(this).find('.arrow').length >= 1) {
			if(jQuery(this).parent().find('> .children').length >= 1 && !$(this).parent().find('> .children').is(':visible')) {
				jQuery(this).parent().find('> .children').stop(true, true).slideDown('slow');
			} else {
				jQuery(this).parent().find('> .children').stop(true, true).slideUp('slow');
			}
		}

		if(jQuery(this).find('.arrow').length >= 1) {
			return false;
		}
	});
	<?php else: ?>
	jQuery('.side-nav li').hoverIntent({
	over: function() {
		if(jQuery(this).find('> .children').length >= 1) {
			jQuery(this).find('> .children').stop(true, true).slideDown('slow');
		}
	},
	out: function() {
		if(jQuery(this).find('.current_page_item').length == 0 && jQuery(this).hasClass('current_page_item') == false) {
			jQuery(this).find('.children').stop(true, true).slideUp('slow');
		}
	},
	timeout: 500
	});
	<?php endif; ?>

	if(jQuery().eislideshow) {
        jQuery('#ei-slider').eislideshow({
        	<?php if($data["tfes_animation"]): ?>
        	animation: '<?php echo $data["tfes_animation"]; ?>',
        	<?php endif; ?>
        	autoplay: <?php if($data["tfes_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
        	<?php if($data["tfes_interval"]): ?>
        	slideshow_interval: <?php echo $data['tfes_interval']; ?>,
        	<?php endif; ?>
        	<?php if($data["tfes_speed"]): ?>
        	speed: <?php echo $data['tfes_speed']; ?>,
        	<?php endif; ?>
        	<?php if($data["tfes_width"]): ?>
        	thumbMaxWidth: <?php echo $data['tfes_width']; ?>
        	<?php endif; ?>
        });
	}

    var retina = window.devicePixelRatio > 1 ? true : false;

    <?php if($data['custom_icon_image_retina']): ?>
    if(retina) {
    	jQuery('.social-networks li.custom').each(function() {
    		jQuery(this).find('img').attr('src', '<?php echo $data["custom_icon_image_retina"]; ?>');
        	jQuery(this).find('img').attr('width', '<?php echo $data["retina_icon_width"]; ?>');
        	jQuery(this).find('img').attr('height', '<?php echo $data["retina_icon_height"]; ?>');
    	})
    }
    <?php endif; ?>

    /* wpml flag in center */
	var wpml_flag = jQuery('ul#navigation > li > a > .iclflag');
	var wpml_h = wpml_flag.height();
	wpml_flag.css('margin-top', +wpml_h / - 2 + "px");

	var wpml_flag = jQuery('.top-menu > ul > li > a > .iclflag');
	var wpml_h = wpml_flag.height();
	wpml_flag.css('margin-top', +wpml_h / - 2 + "px");

	<?php if($data['blog_pagination_type'] == 'Infinite Scroll' || is_page_template('demo-gridblog.php')  || is_page_template('demo-timelineblog.php')): ?>
	jQuery('#posts-container').infinitescroll({
	    navSelector  : "div.pagination",
	                   // selector for the paged navigation (it will be hidden)
	    nextSelector : "a.pagination-next",
	                   // selector for the NEXT link (to page 2)
	    itemSelector : "div.post, .timeline-date",
	                   // selector for all items you'll retrieve
		loading      : {
						finishedMsg: js_local_vars.infinte_blog_finished_msg,
						msgText: js_local_vars.infinte_blog_text,
		},
	    errorCallback: function() {
	    	jQuery('#posts-container').isotope('reLayout');
	    }
	}, function(posts) {
		if(jQuery().isotope) {
			//jQuery(posts).css('position', 'relative').css('top', 'auto').css('left', 'auto');

			jQuery(posts).hide();
			imagesLoaded(posts, function() {
				jQuery(posts).fadeIn();
				jQuery('#posts-container').isotope('appended', jQuery(posts));
				jQuery('#posts-container').isotope('reLayout');
			});

			var gridwidth = (jQuery('.grid-layout').width() / 2) - 22;
			jQuery('.grid-layout .post').css('width', gridwidth);

			var gridwidth = (jQuery('.grid-full-layout-3').width() / 3) - 30;
			jQuery('.grid-full-layout-3 .post').css('width', gridwidth);

			var gridwidth = (jQuery('.grid-full-layout-4').width() / 4) - 35;
			jQuery('.grid-full-layout-4 .post').css('width', gridwidth);

			jQuery('#posts-container').isotope('reLayout');
		}

		jQuery('.flexslider').flexslider({
			slideshow: <?php if($data["slideshow_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
			slideshowSpeed: <?php if($data['slideshow_speed']) { echo $data['slideshow_speed']; } else { echo '7000'; } ?>,
			video: true,
			pauseOnHover: false,
			useCSS: false,
			start: function(slider) {
		        if (typeof(slider.slides) !== 'undefined' && slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
			},
		    before: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if(!$data['status_vimeo']): ?>$f(slider.slides.eq(slider.currentSlide).find('iframe')[0] ).api('pause');<?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>

		           /* ------------------  YOUTUBE FOR AUTOSLIDER ------------------ */
		           playVideoAndPauseOthers(slider);
		       }
		    },
		   	after: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>
		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
		    }
		});
		if(jQuery().prettyPhoto) { jQuery("a[rel^='prettyPhoto']").prettyPhoto(ppArgs); }
		jQuery(posts).each(function() {
			jQuery(this).find('.full-video, .video-shortcode, .wooslider .slide-content').fitVids();
		});

		if(jQuery().isotope) {
			jQuery('#posts-container').isotope('reLayout');
		}
	});
	<?php endif; ?>

	jQuery('#posts-container-infinite').infinitescroll({
	    navSelector  : "div.pagination",
	                   // selector for the paged navigation (it will be hidden)
	    nextSelector : "a.pagination-next",
	                   // selector for the NEXT link (to page 2)
	    itemSelector : "div.post, .timeline-date",
	                   // selector for all items you'll retrieve
		loading      : {
						finishedMsg: js_local_vars.infinte_blog_finished_msg,
						msgText: js_local_vars.infinte_blog_text,
		},
	    errorCallback: function() {
	    	jQuery('#posts-container').isotope('reLayout');
	    }
	}, function(posts) {
		if(jQuery().isotope) {
			//jQuery(posts).css('top', 'auto').css('left', 'auto');

			jQuery(posts).hide();
			imagesLoaded(posts, function() {
				jQuery(posts).fadeIn();
				jQuery('#posts-container-infinite').isotope('appended', jQuery(posts));
				jQuery('#posts-container-infinite').isotope('reLayout');
			});

			var gridwidth = (jQuery('.grid-layout').width() / 2) - 22;
			jQuery('.grid-layout .post').css('width', gridwidth);

			var gridwidth = (jQuery('.grid-full-layout-3').width() / 3) - 30;
			jQuery('.grid-full-layout-3 .post').css('width', gridwidth);

			var gridwidth = (jQuery('.grid-full-layout-4').width() / 4) - 35;
			jQuery('.grid-full-layout-4 .post').css('width', gridwidth);

			jQuery('#posts-container-infinite').isotope('reLayout');
		}

		jQuery('.flexslider').flexslider({
			slideshow: <?php if($data["slideshow_autoplay"]) { echo 'true'; } else { echo 'false'; } ?>,
			slideshowSpeed: <?php if($data['slideshow_speed']) { echo $data['slideshow_speed']; } else { echo '7000'; } ?>,
			video: true,
			pauseOnHover: false,
			useCSS: false,
			start: function(slider) {
		        if (typeof(slider.slides) !== 'undefined' && slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
			},
		    before: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if(!$data['status_vimeo']): ?>$f(slider.slides.eq(slider.currentSlide).find('iframe')[0] ).api('pause');<?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>

		           /* ------------------  YOUTUBE FOR AUTOSLIDER ------------------ */
		           playVideoAndPauseOthers(slider);
		       }
		    },
		   	after: function(slider) {
		        if (slider.slides.eq(slider.currentSlide).find('iframe').length !== 0) {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '-30px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').hide();
		           <?php endif; ?>

		           <?php if(!$data['status_yt']): ?>
		           if(window.yt_vid_exists == true) {
					YT_ready(function() {
						new YT.Player(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), {
							events: {
								'onStateChange': onPlayerStateChange(slider.slides.eq(slider.currentSlide).find('iframe').attr('id'), slider)
							}
						});
					});
					}
					<?php endif; ?>
		       } else {
		           <?php if($data['pagination_video_slide']): ?>
		           jQuery(slider).find('.flex-control-nav').css('bottom', '0px');
		           <?php else: ?>
		           jQuery(slider).find('.flex-control-nav').show();
		           <?php endif; ?>
		       }
		    }
		});
		if(jQuery().prettyPhoto) { jQuery("a[rel^='prettyPhoto']").prettyPhoto(ppArgs); }
		jQuery(posts).each(function() {
			jQuery(this).find('.full-video, .video-shortcode, .wooslider .slide-content').fitVids();
		});

		if(jQuery().isotope) {
			jQuery('#posts-container-infinite').isotope('reLayout');
		}
	});

	<?php if($data['grid_pagination_type'] == 'Infinite Scroll'): ?>
	jQuery('.portfolio-masonry .portfolio-wrapper').infinitescroll({
	   	//behavior: 'local',
	    //binder: jQuery('.portfolio-infinite .portfolio-wrapper'),
	    navSelector  : "div.pagination",
	                   // selector for the paged navigation (it will be hidden)
	    nextSelector : "a.pagination-next",
	                   // selector for the NEXT link (to page 2)
	    itemSelector : "div.portfolio-item",
	                   // selector for all items you'll retrieve
		loading      : {
						finishedMsg: js_local_vars.infinte_finished_msg,
						msgText: js_local_vars.infinte_blog_text,
		},
	    errorCallback: function() {
	    	//jQuery('.portfolio-masonry .portfolio-wrapper').isotope('reLayout');
	    },
	    contentSelector: jQuery('.portfolio-masonry .portfolio-wrapper'),
	}, function(posts) {
		if(jQuery().isotope) {
			//jQuery(posts).css('position', 'relative').css('top', 'auto').css('left', 'auto');

			jQuery(posts).hide();

			imagesLoaded(jQuery(posts), function() {
				jQuery(posts).fadeIn();

				jQuery('.portfolio-masonry .portfolio-wrapper').isotope('appended', jQuery(posts));

				if(jQuery().prettyPhoto) { jQuery("a[rel^='prettyPhoto']").prettyPhoto(ppArgs); }

				jQuery(posts).each(function() {
					jQuery(this).find('.full-video, .video-shortcode, .wooslider .slide-content').fitVids();
				});

				jQuery('.portfolio-masonry .portfolio-wrapper').isotope('reLayout');
			});

			//});

			/*var gridwidth = (jQuery('.grid-layout').width() / 2) - 22;
			jQuery('.grid-layout .post').css('width', gridwidth);

			var gridwidth = (jQuery('.grid-full-layout').width() / 3) - 30;
			jQuery('.grid-full-layout .post').css('width', gridwidth);*/

			//jQuery('.portfolio-masonry .portfolio-wrapper').isotope('reLayout');
		}
	});
	<?php endif; ?>
});