<?php
//start session
session_start();

/**
 * Contact form with file attachment
 * Release Date: April 24th 2008
 * Author: Elle Meredith <http://designbyelle.com.au/>
 * 
 * Resources used to create this script
 * phMailer <http://www.phphq.net?script=phMailer> by Scott L. <scott@phphq.net>
 * an article on Sitepoint by Kevin Yank, (13 Feb 2003) Accessed on April 24, 2008
 * "Advanced email in PHP" <http://www.sitepoint.com/article/advanced-email-php>
 * and "PHP: Sending Email (Text/HTML/Attachments)"
 * <http://www.webcheatsheet.com/php/send_email_text_html_attachment.php>
 *
 * one more: http://www.sebastiansulinski.co.uk/web_design_tutorials/php/php_file_upload.php
 *
 * This script is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This script is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * http://www.gnu.org/licenses/gpl.txt
 *
 */

require_once 'swift/lib/swift_required.php'; 

// prints form
function print_form(){
?>
	<div id="formWrapper">
		
		<form method="post" action="<?php echo $_SERVER[’PHP_SELF’];?>" id="uploadform" enctype="multipart/form-data">
			<p style="font-size:22px; width: 550px;">Vrei sa ne contactezi? Completeaza si trimite formularul de mai jos!</p>
			<br/>
			<p><label for="namefrom">Nume <span class="required">*</span></label>
			<input name="namefrom" id="namefrom" type="text" class="field" value="<?= $_SESSION['myForm']['namefrom']; ?>" tabindex="1"/></p>
			
			<p><label for="emailfrom">Email <span class="required">*</span></label>
			<input name="emailfrom" id="emailfrom" type="text" class="field" value="<?= $_SESSION['myForm']['emailfrom']; ?>" tabindex="3"/></p>
			
			<p><label for="subject">Subiect <span class="required">*</span></label>
				<select name="subject" id="subject" type="text" class="field" value="<?= $_SESSION['myForm']['subject']; ?>" tabindex="5">
					<option value="Contabilitate">Contabilitate</option>
					<option value="Reclamatie">Reclamatie</option>
					<option value="Colaborare">Colaborare</option>
				</select>
			</p>
			
			
			<p><label for="comments">Mesaj <span class="required">*</span></label>
			<textarea name="comments" id="comments" rows="7" cols="10" class="field" tabindex="6"><?= $_SESSION['myForm']['comments']; ?></textarea></p>
			
			<!--<p><label for="attachment">Incarca fisier<br />(Doar un fisier, dimensiune maxima 1024kb. Formate permise .doc, .pdf, .docx, .odt)</label>
			<input name="attachment" id="attachment" type="file" tabindex="7">-->
			
			<p><input type="submit" name="submit" id="submit" value="Trimite"  tabindex="8"/></p>
			<p><input type="hidden" name="submitted"  value="true" /></p>
			
			<br/><br/>
			<p class="obligatorii" style="top:380px;"><span class="required">*</span> Campuri obligatorii</p>
		</form>
		
	</div>
	
	<div class="formRight">
		<b style="font-size:20px; letter-spacing: 2px;">SC Farmaplus SRL</b>
		<br/>
		<ul>                                                                          
			<li>Adresa: Strada Tache Ionescu nr 5, sect 1, Bucuresti.              </li>
			<li>Numar de inmatriculare la Registrul Comertului: J40/5477/1991      </li>
			<li>Cod fiscal: RO 413600                                              </li>
			<li>Email: contact@farma-plus.ro                                       </li>
		</ul>
	</div>
<?php
}

// enquiry form validation

function process_form() {

	// Set SMTP connection details
	$transport          = Swift_SmtpTransport::newInstance()
    ->setHost('smtp.live.com') // Host.  This should not need to change
    ->setPort(587) // Port.  Should not be changed as SwiftMail does not support starttls
    ->setUsername('farma-plus@outlook.com')
    ->setPassword('devpass112!')
    ->setEncryption('tls') // set the encription type.
    ;

	// Create a Mailer
	$mailer             = Swift_Mailer::newInstance($transport);

	// Read POST request params into global vars
	// FILL IN YOUR EMAIL
	$to = "contact@farma-plus.ro";//array("raduanastase@gmail.com","anastaseradu@gmail.com","foto@raduanastase.com");
	$subject = trim($_POST['subject']);
	$namefrom = trim($_POST['namefrom']);
	//$company = trim($_POST['company']);
	//$phone = trim($_POST['phone']);
	$emailfrom = trim($_POST['emailfrom']);
	$comments = trim($_POST['comments']);
	//var_dump($to[2]);
	// Allowed file types. add file extensions WITHOUT the dot.
	$allowtypes=array("docx", "odt", "doc", "pdf");
	
	$send_to            = array($to);
	$sent_from			= array($emailfrom);//trim($_POST['emailfrom']) => trim($_POST['namefrom']));
	
	// Require a file to be attached: false = Do not allow attachments true = allow only 1 file to be attached
	$requirefile="false";
	
	// Maximum file size for attachments in KB NOT Bytes for simplicity. MAKE SURE your php.ini can handel it,
	// post_max_size, upload_max_filesize, file_uploads, max_execution_time!
	// 2048kb = 2MB,       1024kb = 1MB,     512kb = 1/2MB etc..
	$max_file_size="1024";
	
	// Thank you message
	$thanksmessage="Mesajul s-a trimis. Va vom contacta in cel mai scurt timp.";

	$errors = array(); //Initialize error array

	//checks for a name
	if (empty($_POST['namefrom']) ) {
		$errors[]='Ati uitat sa va introduceti numele.';
		}

	//checks for an email
	if (empty($_POST['emailfrom']) ) {
		$errors[]='Ati uitat sa introduceti un email.';
		} else {

		if (!eregi ('^[[:alnum:]][a-z0-9_\.\-]*@[a-z0-9\.\-]+\.[a-z]{2,4}$', stripslashes(trim($_POST['emailfrom'])))) {
			$errors[]='Introduceti o adresa de email valida.';
		} // if eregi
	} // if empty email

	//checks for a subject
	if (empty($_POST['subject']) ) {
		$errors[]='Ati uitat sa alegeti un post.';
		}

	//checks for a message
	if (empty($_POST['comments']) ) {
		$errors[]='Ati uitat sa introduceti un mesaj.';
		}
		
 	// checks for required file
	// http://amiworks.co.in/talk/handling-file-uploads-in-php/
	if($requirefile=="true") {
		if($_FILES['attachment']['error']==4) {
			$errors[]='Ati uitat sa atatsati un fisier.';
		}
	}
		
	//checks attachment file
	// checks that we have a file
	if((!empty($_FILES["attachment"])) && ($_FILES['attachment']['error'] == 0)) {
			// basename -- Returns filename component of path
			$filename = basename($_FILES['attachment']['name']);
			$ext = substr($filename, strrpos($filename, '.') + 1);
			$filesize=$_FILES['attachment']['size'];
			$max_bytes=$max_file_size*1024;
			
			//Check if the file type uploaded is a valid file type. 
			if (!in_array($ext, $allowtypes)) {
				$errors[]="Extensie nepermisa pentru fisier: <strong>".$filename."</strong>";
				
		// check the size of each file
		} elseif($filesize > $max_bytes) {
				$errors[]= "Fisierul: <strong>".$filename."</strong> este prea mare. Marimea maxima a fisierului poate fi de ".$max_file_size."kb.";
			}
			
	} // if !empty FILES

	if (empty($errors)) { //If everything is OK
	
		
		// send an email
		// Obtain file upload vars
		
		$fileatt      = $_FILES['attachment']['name'];
		$fileatt_type = "application/octet-stream"; // File Type //$_FILES['attachment']['type'];
		$fileatt_name = $_FILES['attachment']['name'];
		
		// Headers
		$headers = "From: $emailfrom";
		
		// create a boundary string. It must be unique
		  $semi_rand = md5(time());
		  $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";

		  // Add the headers for a file attachment
		  $headers .= "\nMIME-Version: 1.0\n" .
		              "Content-Type: multipart/mixed;\n" .
		              " boundary=\"{$mime_boundary}\"";

		  // Add a multipart boundary above the plain message
		  $message ="This is a multi-part message in MIME format.\n\n";
		  $message.="--{$mime_boundary}\n";
		  $message.="Content-Type: text/plain; charset=\"iso-8859-1\"\n";
		  $message.="Content-Transfer-Encoding: 7bit\n\n";
		  $message.="From: ".$namefrom."\n";
		  $message.="Comments: ".$comments."\n\n";
		
		if (is_uploaded_file($fileatt)) {
		  // Read the file to be attached ('rb' = read binary)
			//MINE
			$base = basename($_FILES['attachment']['name']);
			$file = fopen($randname_path,'rb');
			$size = filesize($randname_path);
			$data = fread($file,$size);
			fclose($file);
			//END MINE
		  //$file = fopen($fileatt,'rb');
		  //$data = fread($file,filesize($fileatt));
		  //fclose($file);

		  // Base64 encode the file data
		  $data = chunk_split(base64_encode($data));

		  // Add file attachment to the message
		  $message .= "--{$mime_boundary}\n" .
		              "Content-Type: {$fileatt_type};\n" .
		              " name=\"{$fileatt_name}\"\n" .
		              //"Content-Disposition: attachment;\n" .
		              //" filename=\"{$fileatt_name}\"\n" .
		              "Content-Transfer-Encoding: base64\n\n" .
		              $data . "\n\n" .
		              "--{$mime_boundary}--\n";
		}
		
		
		// Send the completed message
		
		$envs = array("HTTP_USER_AGENT", "REMOTE_ADDR", "REMOTE_HOST");
		foreach ($envs as $env)
		$message .= "$env: $_SERVER[$env]\n";
		
		//$toFinal = $to[0];
		//if($subject=="Contabilitate") {
		//	$toFinal = $to[0];
		//} else if($subject=="Reclamatie") {
		//	$toFinal = $to[1];
		//} else {
		//	$toFinal = $to[2];
		//}
		//print_r($toFinal);
		
		// Construct the message
		$swift_message            = Swift_Message::newInstance()
			->setSubject($subject) // Set Subject line here
			->setContentType('text/html') // Sets the Content-Type
			->setFrom($sent_from) // Sets the sender address specified at the top
			->setTo($send_to) // Sets the recipient addresses sprecified at the top
			->setBody("<b>Mesaj primit de la:</b> ".$sent_from[0] ."\n <br/><br/><b>Cu urmatorul mesaj:</b> ". $comments) // Sets the body of the email
			;
		
		// if(!mail($to,$subject,$message,$headers)) {
			// exit("Ne pare rau, mesajul nu a putut fi trimis!");
		// } else {
			// echo '<div id="formfeedback"><h3>Va multumim!</h3><p>'. $thanksmessage .'</p></div>';
			// unset($_SESSION['myForm']);
			// print_form();
			
		// } // end of if !mail
		
		// $result will be an integer representing the number of successful recipients
		$result = $mailer->send($swift_message);
		
		if($result > 0) {
			echo '<div id="formfeedback"><h3>Va multumim!</h3><p>'. $thanksmessage .'</p></div>';
			unset($_SESSION['myForm']);
		} else exit("Ne pare rau, mesajul nu a putut fi trimis, mai incercati!");
		
	} else { //report the errors
		echo '<div id="formfeedback"><h3>Eroare!</h3><p>A intervenit urmatoarea eroare:<br />';
		foreach ($errors as $msg) { //prints each error
				echo " - $msg<br />\n";
			} // end of foreach
		echo '</p><p>Va rugam, incercati din nou!</p></div>';
		print_form();
	} //end of if(empty($errors))

} // end of process_form()
?>



